/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.instance;

import dev.engine_room.flywheel.api.instance.InstanceHandle;
import dev.engine_room.flywheel.api.instance.InstanceType;
import dev.engine_room.flywheel.lib.instance.ColoredLitOverlayInstance;
import dev.engine_room.flywheel.lib.transform.Rotate;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class OrientedInstance
extends ColoredLitOverlayInstance
implements Rotate<OrientedInstance> {
    public float posX;
    public float posY;
    public float posZ;
    public float pivotX = 0.5f;
    public float pivotY = 0.5f;
    public float pivotZ = 0.5f;
    public final Quaternionf rotation = new Quaternionf();

    public OrientedInstance(InstanceType<? extends OrientedInstance> type, InstanceHandle handle) {
        super((InstanceType<? extends ColoredLitOverlayInstance>)type, handle);
    }

    public OrientedInstance position(float x, float y, float z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        return this;
    }

    public OrientedInstance position(Vector3fc pos) {
        return this.position(pos.x(), pos.y(), pos.z());
    }

    public OrientedInstance position(class_2382 pos) {
        return this.position(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public OrientedInstance position(class_243 pos) {
        return this.position((float)pos.method_10216(), (float)pos.method_10214(), (float)pos.method_10215());
    }

    public OrientedInstance zeroPosition() {
        return this.position(0.0f, 0.0f, 0.0f);
    }

    public OrientedInstance translatePosition(float x, float y, float z) {
        this.posX += x;
        this.posY += y;
        this.posZ += z;
        return this;
    }

    public OrientedInstance pivot(float x, float y, float z) {
        this.pivotX = x;
        this.pivotY = y;
        this.pivotZ = z;
        return this;
    }

    public OrientedInstance pivot(Vector3fc pos) {
        return this.pivot(pos.x(), pos.y(), pos.z());
    }

    public OrientedInstance pivot(class_2382 pos) {
        return this.pivot(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public OrientedInstance pivot(class_243 pos) {
        return this.pivot((float)pos.method_10216(), (float)pos.method_10214(), (float)pos.method_10215());
    }

    public OrientedInstance centerPivot() {
        return this.pivot(0.5f, 0.5f, 0.5f);
    }

    public OrientedInstance translatePivot(float x, float y, float z) {
        this.pivotX += x;
        this.pivotY += y;
        this.pivotZ += z;
        return this;
    }

    public OrientedInstance rotation(Quaternionfc q) {
        this.rotation.set(q);
        return this;
    }

    public OrientedInstance rotation(float x, float y, float z, float w) {
        this.rotation.set(x, y, z, w);
        return this;
    }

    public OrientedInstance identityRotation() {
        this.rotation.identity();
        return this;
    }

    @Override
    public OrientedInstance rotate(Quaternionfc quaternion) {
        this.rotation.mul(quaternion);
        return this;
    }
}

